<?php

namespace App\Http\Controllers;

use App\Models\DAMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DAMasterController extends Controller
{
    // =====================
    // INDEX (15 per page)
    // =====================
    public function index()
    {
        $data = DAMaster::with('commission')
            ->orderBy('da_id', 'desc')
            ->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }
    // =====================
    // GET ALL (NO PAGINATION)
    // =====================
    public function all()
    {
        $data = DAMaster::with('commission')
            ->orderBy('da_id', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'total' => $data->count(),
            'data' => $data
        ]);
    }

    // =====================
    // STORE (all nullable)
    // =====================
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'commission_id' => 'nullable|exists:pay_commission_masters,commission_id'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $da = DAMaster::create([
            'da_sr'         => $request->da_sr,
            'fr_date'       => $request->fr_date,
            'to_date'       => $request->to_date,
            'eff_date'      => $request->eff_date,
            'commission_id' => $request->commission_id,
            'da_rate'       => $request->da_rate,
            'da_paid'       => $request->da_paid,
            'da_diff'       => $request->da_diff,
            'npa_rate'      => $request->npa_rate,
            'npa_limit'     => $request->npa_limit,
            'dapf'          => $request->dapf,
            'bon_limit'     => $request->bon_limit,
            'ir_rate'       => $request->ir_rate,
            'da_diff_mon'   => $request->da_diff_mon,
            'da_diff_rate'  => $request->da_diff_rate,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'DA Master created successfully',
            'data' => $da
        ], 201);
    }

    // =====================
    // SHOW
    // =====================
    public function show($id)
    {
        $data = DAMaster::with('commission')->findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }

    // =====================
    // UPDATE (sometimes)
    // =====================
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'commission_id' => 'sometimes|nullable|exists:pay_commission_masters,commission_id'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $da = DAMaster::findOrFail($id);

        $da->update($request->only([
            'da_sr',
            'fr_date',
            'to_date',
            'eff_date',
            'commission_id',
            'da_rate',
            'da_paid',
            'da_diff',
            'npa_rate',
            'npa_limit',
            'dapf',
            'bon_limit',
            'ir_rate',
            'da_diff_mon',
            'da_diff_rate'
        ]));

        return response()->json([
            'success' => true,
            'message' => 'DA Master updated successfully',
            'data' => $da
        ]);
    }

    // =====================
    // DELETE
    // =====================
    public function destroy($id)
    {
        DAMaster::findOrFail($id)->delete();

        return response()->json([
            'success' => true,
            'message' => 'DA Master deleted successfully'
        ]);
    }
}
