<?php

namespace App\Http\Controllers;

use App\Models\DepartmentMenuMapping;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\MainDepartment;
use App\Models\FunctionType;
class DepartmentMenuMappingController extends Controller
{
    // =============================
    // LIST ALL
    // =============================


public function index()
{
    $data = DepartmentMenuMapping::all();

    $data = $data->map(function ($item) {

        return [
            'Dept_menu_map_Id' => $item->Dept_menu_map_Id,
            'Menu_ID' => $item->Menu_ID,
            'menu' => FunctionType::find($item->Menu_ID),   // ✅ menu details
            'Dept_IDs' => $item->Dept_IDs,
            'departments' => MainDepartment::whereIn('id', $item->Dept_IDs)->get(), // ✅ dept details
            'Status' => $item->Status,
            'created_at' => $item->created_at,
            'updated_at' => $item->updated_at
        ];
    });

    return response()->json([
        'success' => true,
        'data' => $data
    ]);
}


    // =============================
    // STORE
    // =============================
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'Menu_ID' => 'required|integer|exists:function_types,id',
            'Dept_IDs' => 'required|array',
            'Dept_IDs.*' => 'integer|exists:main_departments,id'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success'=>false,
                'errors'=>$validator->errors()
            ],422);
        }

        $mapping = DepartmentMenuMapping::create([
            'Menu_ID' => $request->Menu_ID,
            'Dept_IDs' => $request->Dept_IDs,
            'Status' => 1
        ]);

        return response()->json([
            'success'=>true,
            'message'=>'Mapping created successfully',
            'data'=>$mapping
        ]);
    }

    // =============================
    // SHOW
    // =============================
public function show($id)
{
    $item = DepartmentMenuMapping::find($id);

    if(!$item){
        return response()->json([
            'success'=>false,
            'message'=>'Record not found'
        ],404);
    }

    $data = [
        'Dept_menu_map_Id' => $item->Dept_menu_map_Id,
        'Menu_ID' => $item->Menu_ID,
        'menu' => FunctionType::find($item->Menu_ID),   // ✅ menu details
        'Dept_IDs' => $item->Dept_IDs,
        'departments' => MainDepartment::whereIn('id', $item->Dept_IDs)->get(), // ✅ dept details
        'Status' => $item->Status,
        'created_at' => $item->created_at,
        'updated_at' => $item->updated_at
    ];

    return response()->json([
        'success'=>true,
        'data'=>$data
    ]);
}
    // =============================
    // UPDATE
    // =============================
    public function update(Request $request,$id)
    {
        $mapping = DepartmentMenuMapping::find($id);

        if(!$mapping){
            return response()->json([
                'success'=>false,
                'message'=>'Record not found'
            ],404);
        }

        $validator = Validator::make($request->all(),[
            'Menu_ID' => 'sometimes|integer|exists:function_types,id',
            'Dept_IDs' => 'sometimes|array',
            'Dept_IDs.*' => 'integer|exists:main_departments,id',
            'Status' => 'sometimes|boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success'=>false,
                'errors'=>$validator->errors()
            ],422);
        }

        $mapping->update($request->only([
            'Menu_ID',
            'Dept_IDs',
            'Status'
        ]));

        return response()->json([
            'success'=>true,
            'message'=>'Updated successfully',
            'data'=>$mapping
        ]);
    }

    // =============================
    // DELETE
    // =============================
    public function destroy($id)
    {
        $mapping = DepartmentMenuMapping::find($id);

        if(!$mapping){
            return response()->json([
                'success'=>false,
                'message'=>'Record not found'
            ],404);
        }

        $mapping->delete();

        return response()->json([
            'success'=>true,
            'message'=>'Deleted successfully'
        ]);
    }
}
