<?php

namespace App\Http\Controllers;

use App\Models\PayStructureTypeMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PayStructureTypeMasterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $structureTypes = PayStructureTypeMaster::all();
        return response()->json([
            'success' => true,
            'data' => $structureTypes
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'structure_type' => 'required|string|max:30|unique:pay_structure_type_masters,structure_type'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $structureType = PayStructureTypeMaster::create($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Pay Structure Type created successfully',
            'data' => $structureType
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $structureType = PayStructureTypeMaster::find($id);

        if (!$structureType) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Structure Type not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $structureType
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $structureType = PayStructureTypeMaster::find($id);

        if (!$structureType) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Structure Type not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'structure_type' => 'required|string|max:30|unique:pay_structure_type_masters,structure_type,' . $id . ',structure_type_id'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $structureType->update($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Pay Structure Type updated successfully',
            'data' => $structureType
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $structureType = PayStructureTypeMaster::find($id);

        if (!$structureType) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Structure Type not found'
            ], 404);
        }

        $structureType->delete();

        return response()->json([
            'success' => true,
            'message' => 'Pay Structure Type deleted successfully'
        ]);
    }
}
