<?php

namespace App\Http\Controllers;

use App\Models\QualificationLevel;
use Illuminate\Http\Request;

class QualificationLevelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $qualificationLevels = QualificationLevel::all();
        return response()->json($qualificationLevels);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'code' => 'nullable|string|unique:qualification_levels|max:50',
            'name' => 'required|string|max:255'
        ]);

        $qualificationLevel = QualificationLevel::create($request->all());
        return response()->json($qualificationLevel, 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $qualificationLevel = QualificationLevel::find($id);

        if (!$qualificationLevel) {
            return response()->json(['message' => 'Qualification level not found'], 404);
        }

        return response()->json($qualificationLevel);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $qualificationLevel = QualificationLevel::find($id);

        if (!$qualificationLevel) {
            return response()->json(['message' => 'Qualification level not found'], 404);
        }

        $request->validate([
            'code' => 'nullable|string|max:50|unique:qualification_levels,code,' . $id,
            'name' => 'required|string|max:255'
        ]);

        $qualificationLevel->update($request->all());
        return response()->json($qualificationLevel);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $qualificationLevel = QualificationLevel::find($id);

        if (!$qualificationLevel) {
            return response()->json(['message' => 'Qualification level not found'], 404);
        }

        $qualificationLevel->delete();
        return response()->json(['message' => 'Qualification level deleted successfully']);
    }
}
