<?php

namespace App\Http\Controllers;

use App\Models\RecruitmentType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RecruitmentTypeController extends Controller
{
    // ✅ INDEX
    public function index()
    {
        return response()->json([
            'success' => true,
            'data' => RecruitmentType::all()
        ]);
    }

    // ✅ STORE (ALL NULLABLE)
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'employee_code' => 'nullable|unique:recruitment_types,employee_code',
            'employee_name' => 'nullable|string|max:100'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $data = RecruitmentType::create($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Recruitment Type created successfully',
            'data' => $data
        ], 201);
    }

    // ✅ SHOW
    public function show($id)
    {
        $data = RecruitmentType::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Recruitment Type not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }

    // ✅ UPDATE (NULLABLE SOMETIMES)
    public function update(Request $request, $id)
    {
        $data = RecruitmentType::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Recruitment Type not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'employee_code' => 'nullable|unique:recruitment_types,employee_code,' . $id . ',recruitment_type_id',
            'employee_name' => 'nullable|string|max:100'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $data->update($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Recruitment Type updated successfully',
            'data' => $data
        ]);
    }

    // ✅ DELETE
    public function destroy($id)
    {
        $data = RecruitmentType::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Recruitment Type not found'
            ], 404);
        }

        $data->delete();

        return response()->json([
            'success' => true,
            'message' => 'Recruitment Type deleted successfully'
        ]);
    }
}
