<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\SchemeTypeMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SchemeTypeMasterController extends Controller
{
    public function index()
    {
        $schemeTypes = SchemeTypeMaster::where('is_active', true)->get();
        return response()->json([
            'success' => true,
            'data' => $schemeTypes
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'scheme_type_code' => 'nullable|string|max:20|unique:scheme_type_master,scheme_type_code',
            'scheme_type_name' => 'required|string|max:150',
            'funding_source' => 'nullable|string|max:100',
            'description' => 'nullable|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $schemeType = SchemeTypeMaster::create($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Scheme type created successfully',
            'data' => $schemeType
        ], 201);
    }

    public function show($id)
    {
        $schemeType = SchemeTypeMaster::find($id);

        if (!$schemeType) {
            return response()->json([
                'success' => false,
                'message' => 'Scheme type not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $schemeType
        ]);
    }

    public function update(Request $request, $id)
    {
        $schemeType = SchemeTypeMaster::find($id);

        if (!$schemeType) {
            return response()->json([
                'success' => false,
                'message' => 'Scheme type not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'scheme_type_code' => 'nullable|string|max:20|unique:scheme_type_master,scheme_type_code,' . $id . ',scheme_type_id',
            'scheme_type_name' => 'required|string|max:150',
            'funding_source' => 'nullable|string|max:100',
            'description' => 'nullable|string|max:255',
            'is_active' => 'boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $schemeType->update($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Scheme type updated successfully',
            'data' => $schemeType
        ]);
    }

    public function destroy($id)
    {
        $schemeType = SchemeTypeMaster::find($id);

        if (!$schemeType) {
            return response()->json([
                'success' => false,
                'message' => 'Scheme type not found'
            ], 404);
        }

        $schemeType->update(['is_active' => false]);

        return response()->json([
            'success' => true,
            'message' => 'Scheme type deactivated successfully'
        ]);
    }

    public function restore($id)
    {
        $schemeType = SchemeTypeMaster::find($id);

        if (!$schemeType) {
            return response()->json([
                'success' => false,
                'message' => 'Scheme type not found'
            ], 404);
        }

        $schemeType->update(['is_active' => true]);

        return response()->json([
            'success' => true,
            'message' => 'Scheme type activated successfully',
            'data' => $schemeType
        ]);
    }
}
