<?php

namespace App\Http\Controllers;

use App\Models\Stream;
use Illuminate\Http\Request;

class StreamController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $streams = Stream::all();
        return response()->json($streams);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'code' => 'nullable|string|unique:streams|max:50',
            'name' => 'required|string|max:255'
        ]);

        $stream = Stream::create($request->all());
        return response()->json($stream, 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $stream = Stream::find($id);

        if (!$stream) {
            return response()->json(['message' => 'Stream not found'], 404);
        }

        return response()->json($stream);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $stream = Stream::find($id);

        if (!$stream) {
            return response()->json(['message' => 'Stream not found'], 404);
        }

        $request->validate([
            'code' => 'nullable|string|max:50|unique:streams,code,' . $id,
            'name' => 'required|string|max:255'
        ]);

        $stream->update($request->all());
        return response()->json($stream);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $stream = Stream::find($id);

        if (!$stream) {
            return response()->json(['message' => 'Stream not found'], 404);
        }

        $stream->delete();
        return response()->json(['message' => 'Stream deleted successfully']);
    }
}
