<?php

namespace App\Http\Controllers;

use App\Models\TaxSlab;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TaxSlabController extends Controller
{
    // =====================
    // PAGINATED LIST
    // =====================
    public function index()
    {
        $data = TaxSlab::orderBy('its_id', 'desc')
            ->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }

    // =====================
    // ALL DATA (NO PAGINATION)
    // =====================
    public function all()
    {
        $data = TaxSlab::orderBy('its_id', 'desc')->get();

        return response()->json([
            'success' => true,
            'total' => $data->count(),
            'data' => $data
        ]);
    }

    // =====================
    // STORE
    // =====================
    public function store(Request $request)
    {
        $data = TaxSlab::create([
            'ef_date'   => $request->ef_date,
            'tax_type'  => $request->tax_type,
            'sl_from'   => $request->sl_from,
            'sl_to'     => $request->sl_to,
            'tax_rate'  => $request->tax_rate,
            'tax_mode'  => $request->tax_mode
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Tax Slab created successfully',
            'data' => $data
        ], 201);
    }

    // =====================
    // SHOW
    // =====================
    public function show($id)
    {
        $data = TaxSlab::findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }

    // =====================
    // UPDATE (sometimes)
    // =====================
    public function update(Request $request, $id)
    {
        $data = TaxSlab::findOrFail($id);

        $data->update($request->only([
            'ef_date',
            'tax_type',
            'sl_from',
            'sl_to',
            'tax_rate',
            'tax_mode'
        ]));

        return response()->json([
            'success' => true,
            'message' => 'Tax Slab updated successfully',
            'data' => $data
        ]);
    }

    // =====================
    // DELETE
    // =====================
    public function destroy($id)
    {
        TaxSlab::findOrFail($id)->delete();

        return response()->json([
            'success' => true,
            'message' => 'Tax Slab deleted successfully'
        ]);
    }
}
