<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AreaMaster extends Model
{
    use HasFactory;

    protected $table = 'area_master';
    protected $primaryKey = 'Area_Id';

    public $timestamps = false; // Since you have Created_Date field

    protected $fillable = [
        'Area_Code',
        'Area_Name',
        'Ward_ID',
        'Created_Date'
    ];

    protected $casts = [
        'Created_Date' => 'datetime',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->Created_Date = $model->Created_Date ?? now();
        });
    }

    
    public function ward()
    {
        return $this->belongsTo(WardMaster::class, 'Ward_ID', 'Ward_Id');
    }
}
