<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BranchM extends Model
{
    use HasFactory;

    protected $table = 'branch_ms';
    protected $primaryKey = 'Br_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Co_Id',
        'br_df',
        'br_nm',
        'br_ad_pr_no',
        'br_ad_pr_nm',
        'br_ad_nr_lm',
        'br_ad_strt',
        'br_ad_area',
        'br_ad_city',
        'br_ad_stat',
        'br_ad_pin_c',
        'br_ph',
        'br_s_rt',
        'br_p_rt',
        'tallydata',
        'tallydata1',
        't_port',
        'op_id',
        'dt_tm',
        'dept_id',
        'br_grp',
        'br_coll_name',
    ];

    // Relationships
    public function coMaster()
    {
        return $this->belongsTo(CoMaster::class, 'Co_Id', 'Co_Id');
    }

    public function parties()
    {
        return $this->hasMany(PrtyMast::class, 'Br_Id', 'Br_Id');
    }
}