<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $table = 'categories';
    protected $primaryKey = 'category_id';
    public $timestamps = true;

    protected $fillable = [
        'category_name',
        'category_code',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationship with SubCategories
    public function subCategories()
    {
        return $this->hasMany(SubCategory::class, 'category_id', 'category_id');
    }

    // Relationship with SubSubCategories through SubCategories
    public function subSubCategories()
    {
        return $this->hasManyThrough(
            SubSubCategory::class,
            SubCategory::class,
            'category_id', // Foreign key on SubCategory table
            'sub_category_id', // Foreign key on SubSubCategory table
            'category_id', // Local key on Category table
            'sub_category_id' // Local key on SubCategory table
        );
    }
}
