<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'department_master';

    // Primary key
    protected $primaryKey = 'Dept_Id';

    // Auto-incrementing
    public $incrementing = true;

    // Key type
    protected $keyType = 'int';

    // Fillable fields
    protected $fillable = [
        'Dept_Code',
        'Dept_Name',
        'Dept_Type'
    ];

    // Casts
    protected $casts = [
        'Dept_Id' => 'integer'
    ];

    // Timestamps
    public $timestamps = true;

    // Add this relationship to Department model
    public function grantMappings()
    {
        return $this->hasMany(GrantDivisionMapping::class, 'dept_id', 'Dept_Id');
    }

    // Optional: Scopes for filtering
    public function scopeByType($query, $type)
    {
        return $query->where('Dept_Type', $type);
    }

    public function scopeActive($query)
    {
        return $query->where('Dept_Type', '!=', 'X');
    }

    public function scopeAllData($query)
    {
        return $query->orderBy('Dept_Id', 'asc');
    }
}
