<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DepartmentMenuMapping extends Model
{
   protected $table = 'department_menu_mappings'; // ✅ plural

    protected $primaryKey = 'Dept_menu_map_Id';

    protected $fillable = [
        'Menu_ID',
        'Dept_IDs',
        'Status'
    ];

    protected $casts = [
        'Dept_IDs' => 'array'
    ];
    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'Dept_Id', 'id');
    }

    public function menu()
    {
        return $this->belongsTo(FunctionType::class, 'Menu_ID', 'id');
    }
}
