<?php
// app/Models/DesignationMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DesignationMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'designation_id';

    protected $fillable = [
        'designation_name',
        'department_name'
    ];

    public function payMappings()
    {
        return $this->hasMany(DesignationPayMapping::class, 'designation_id');
    }
}
