<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DesignationMenu extends Model
{
    use HasFactory;

    protected $table = 'designation_menus';

    protected $fillable = [
        'title',
        'desc',
        // 'category_id',
        'Upgrp',
        'Grcod',
        'Grsrn',
        'Grsh',
        'isvisible',
        'func_id',
        'Menu_Links',
    ];

    protected $casts = [
        'title'       => 'string',
        // 'category_id' => 'integer',
        'func_id'     => 'integer',
        'isvisible'   => 'integer',
        'Grsrn'       => 'string',
        'Grsh'        => 'string',
        'Menu_Links'  => 'string',
    ];

    // public function category()
    // {
    //     return $this->belongsTo(Category::class, 'category_id', 'category_id');
    // }

    public function parentMenu()
    {
        return $this->belongsTo(DesignationMenu::class, 'func_id');
    }

    public function childMenus()
    {
        return $this->hasMany(DesignationMenu::class, 'func_id');
    }

    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }

    public function getIsVisibleAttribute()
    {
        return $this->attributes['isvisible'] == 1 ? 'Active' : 'Inactive';
    }
}
