<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentLibrary extends Model
{
    use HasFactory;

    protected $table = 'document_library';
    protected $primaryKey = 'Doc_Lib';
    public $incrementing = true;
    public $timestamps = true;

    protected $fillable = [
        'Menu_Id',
        'Rec_Id',
        'Description',
        'Doc_Upload',
        'Serial_No'
    ];

    protected $casts = [
        'Doc_Upload' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            // No auto-generation for Rec_Id
            // It will be set by controller as tender ID
        });
    }

    // Relationship with function_types
    public function functionType()
    {
        return $this->belongsTo(FunctionType::class, 'Menu_Id', 'id');
    }

    // Relationship with tender entries
    // Rec_Id stores Tend_Ent_Id
    public function tenderEntry()
    {
        return $this->belongsTo(TenderEntryMaster::class, 'Rec_Id', 'Tend_Ent_Id');
    }

    // Relationship for all documents of a tender
    public function tenderDocuments()
    {
        return $this->hasMany(TenderEntryMaster::class, 'Tend_Ent_Id', 'Rec_Id');
    }

    // Accessor for formatted Doc_Upload
    public function getFormattedDocUploadAttribute()
    {
        if (is_string($this->Doc_Upload)) {
            return json_decode($this->Doc_Upload, true);
        }
        return $this->Doc_Upload;
    }

    // Accessor for file URL
    public function getFileUrlAttribute()
    {
        $uploadData = $this->formatted_doc_upload;
        return $uploadData['public_url'] ?? null;
    }

    // Accessor for storage path
    public function getStoragePathAttribute()
    {
        $uploadData = $this->formatted_doc_upload;
        return $uploadData['storage_path'] ?? null;
    }
}

