<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EMDBGTypeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'emdbg_type_masters';
    protected $primaryKey = 'emdbg_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'emdbg_type_code',
        'emdbg_type_name',
        'percentage'
    ];

    protected $casts = [
        'percentage' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
