<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EducationMaster extends Model
{
    use HasFactory;

    protected $table = 'education_master';
    protected $primaryKey = 'education_id';

    protected $fillable = [
        'qual_code',
        'qual_name',
        'is_active',
        'is_mandatory',
        'is_technical',
        'is_professional',
        'valid_for_recruitment'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_mandatory' => 'string',
        'is_technical' => 'string',
        'is_professional' => 'string',
        'valid_for_recruitment' => 'string'
    ];
}
