<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FasDebtTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'fas_debt_type_master';
    protected $primaryKey = 'debt_type_id';

    protected $fillable = [
        'debt_code',
        'debt_name',
        'dt_cate',
        'dt_lia_type',
        
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];


    const DT_CATE_LONG_TERM = 'Long Term';
    const DT_CATE_SHORT_TERM = 'Short Term';

    const DT_LIA_TYPE_PAYABLE = 'Payable';
    const DT_LIA_TYPE_DEPOSIT = 'Deposit';
    const DT_LIA_TYPE_LOAN = 'Loan';


    public static function getDtCateOptions()
    {
        return [
            self::DT_CATE_LONG_TERM => 'Long Term',
            self::DT_CATE_SHORT_TERM => 'Short Term',
        ];
    }

    public static function getDtLiaTypeOptions()
    {
        return [
            self::DT_LIA_TYPE_PAYABLE => 'Payable',
            self::DT_LIA_TYPE_DEPOSIT => 'Deposit',
            self::DT_LIA_TYPE_LOAN => 'Loan',
        ];
    }
}
