<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinancialYearMaster extends Model
{
    use HasFactory;

    protected $table = 'financial_year_master';
    protected $primaryKey = 'financial_year_id';
    public $timestamps = true;

    protected $fillable = [
        'financial_year_code',
        'financial_year_name',
        'start_date',
        'end_date',
        'is_current_year',
        'is_budget_open',
        'is_transaction_open',
        'is_month_end_closed',
        'is_year_end_closed',
        'previous_year_id',
        'next_year_id',
        'remarks',
        'status',
    ];

    protected $casts = [
        'start_date' => 'date:Y-m-d',
        'end_date' => 'date:Y-m-d',
        'is_current_year' => 'boolean',
        'is_budget_open' => 'boolean',
        'is_transaction_open' => 'boolean',
        'is_month_end_closed' => 'boolean',
        'is_year_end_closed' => 'boolean',
        'previous_year_id' => 'integer',
        'next_year_id' => 'integer',
    ];

    // Relationships
    public function previousYear()
    {
        return $this->belongsTo(FinancialYearMaster::class, 'previous_year_id', 'financial_year_id');
    }

    public function nextYear()
    {
        return $this->belongsTo(FinancialYearMaster::class, 'next_year_id', 'financial_year_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('status', 'ACTIVE');
    }

    public function scopeCurrent($query)
    {
        return $query->where('is_current_year', true);
    }

    public function scopeBudgetOpen($query)
    {
        return $query->where('is_budget_open', true);
    }

    public function scopeTransactionOpen($query)
    {
        return $query->where('is_transaction_open', true);
    }

    public function scopeClosed($query)
    {
        return $query->where('status', 'CLOSED');
    }

    // Helper Methods
    public function isActive()
    {
        return $this->status === 'ACTIVE';
    }

    public function isClosed()
    {
        return $this->status === 'CLOSED';
    }

    public function isLocked()
    {
        return $this->status === 'LOCKED';
    }
}
