<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GmcDeviceApprovalLog extends Model
{
    use HasFactory;

    protected $table = 'gmc_device_approval_logs';
    protected $primaryKey = 'log_id';
    public $timestamps = false;

    protected $fillable = [
        'queue_id',
        'approval_id',
        'user_id',
        'action_type',
        'action_details',
        'device_data',
        'performed_by',
        'ip_address',
        'user_agent',
        'performed_at'
    ];

    protected $casts = [
        'device_data' => 'array',
        'performed_at' => 'datetime'
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(GmcUser::class, 'user_id', 'user_id');
    }

    public function performer()
    {
        return $this->belongsTo(GmcUser::class, 'performed_by', 'user_id');
    }

    public function queue()
    {
        return $this->belongsTo(GmcDeviceRegistrationQueue::class, 'queue_id', 'queue_id');
    }

    public function approval()
    {
        return $this->belongsTo(GmcDeviceApproval::class, 'approval_id', 'approval_id');
    }

    // Static Methods for Logging
    public static function logRegistration($userId, $deviceData, $ipAddress = null, $userAgent = null)
    {
        return self::create([
            'user_id' => $userId,
            'action_type' => 'REGISTRATION_SUBMITTED',
            'action_details' => 'Device registration submitted during user creation',
            'device_data' => $deviceData,
            'ip_address' => $ipAddress,
            'user_agent' => $userAgent,
            'performed_at' => now()
        ]);
    }

    public static function logApproval($queueId, $approvalId, $userId, $performedBy, $actionType, $details)
    {
        return self::create([
            'queue_id' => $queueId,
            'approval_id' => $approvalId,
            'user_id' => $userId,
            'action_type' => $actionType,
            'action_details' => $details,
            'performed_by' => $performedBy,
            'performed_at' => now()
        ]);
    }
}
