<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GmcUserAuditLog extends Model
{
    use HasFactory;

    protected $table = 'gmc_user_audit_log';
    protected $primaryKey = 'audit_id';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'action_type',
        'action_details',
        'ip_address',
        'user_agent',
        'performed_at'
    ];

    protected $casts = [
        'performed_at' => 'datetime'
    ];

    // Relationship with User
    public function user()
    {
        return $this->belongsTo(GmcUser::class, 'user_id', 'user_id');
    }

    // Log actions
    public static function logAction($userId, $actionType, $actionDetails, $ipAddress = null, $userAgent = null)
    {
        return self::create([
            'user_id' => $userId,
            'action_type' => $actionType,
            'action_details' => $actionDetails,
            'ip_address' => $ipAddress,
            'user_agent' => $userAgent,
            'performed_at' => now()
        ]);
    }
}
