<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GmcUserSession extends Model
{
    use HasFactory;

    protected $table = 'gmc_user_sessions';
    protected $primaryKey = 'session_id';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'session_token',
        'ip_address',
        'user_agent',
        'device_info',
        'login_time',
        'last_activity',
        'expires_at',
        'is_active'
    ];

    protected $casts = [
        'login_time' => 'datetime',
        'last_activity' => 'datetime',
        'expires_at' => 'datetime',
        'is_active' => 'boolean'
    ];

    // Relationship with User
    public function user()
    {
        return $this->belongsTo(GmcUser::class, 'user_id', 'user_id');
    }

    // Check if session is expired
    public function isExpired()
    {
        return $this->expires_at->isPast();
    }

    // Update last activity
    public function updateLastActivity()
    {
        $this->update(['last_activity' => now()]);
    }

    // Invalidate session
    public function invalidate()
    {
        $this->update(['is_active' => false]);
    }

    // Scope for active sessions
    public function scopeActive($query)
    {
        return $query->where('is_active', true)
                     ->where('expires_at', '>', now());
    }
}
