<?php
// app/Models/GradePayMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GradePayMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'grade_pay_id';

    protected $fillable = [
        'commission_id',
        'grade_pay'
    ];

    protected $casts = [
        'grade_pay' => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'commission_id');
    }
}
