<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InstrumentMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'instrument_masters';
    protected $primaryKey = 'inst_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'inst_type_code',
        'inst_type_name'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    /**
     * Scope to filter active records
     */
    public function scopeActive($query)
    {
        return $query->whereNull('deleted_at');
    }

    /**
     * Scope to search by code or name
     */
    public function scopeSearch($query, $searchTerm)
    {
        return $query->where(function($q) use ($searchTerm) {
            $q->where('inst_type_code', 'like', '%' . $searchTerm . '%')
              ->orWhere('inst_type_name', 'like', '%' . $searchTerm . '%');
        });
    }
}
