<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LedgGrp extends Model
{
    use HasFactory;

    protected $table = 'ledg_grps';
    protected $primaryKey = 'Gr_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Org_Id', 'gr_code', 'up_gr', 'gr_nm', 'gr_sr', 'gr_alt', 'gr_stt',
        'gr_al_c', 'GIFI_Code', 'is_del', 'gr_exp', 'gr_buk', 'gr_prt',
        'op_id', 'dt_tm', 'naof_grp', 'credition', 'eff_gp', 'eff_sub_led',
        // Existing fields that match FunctionType
        'Grsh', 'Grsrn', 'Grcod', 'Upgrp',
    ];

    protected $casts = [
        'gr_sr'  => 'integer',
        'gr_stt' => 'integer',
        'Grsrn'  => 'integer', // Already exists
    ];

    // Relationships
    public function OrganisationSetting(): BelongsTo
    {
        return $this->belongsTo(CoMaster::class, 'Org_Id', 'Org_Id');
    }

    public function parentGroup(): BelongsTo
    {
        return $this->belongsTo(LedgGrp::class, 'up_gr', 'gr_code')
            ->where('Co_Id', $this->Co_Id);
    }

    public function childGroups(): HasMany
    {
        return $this->hasMany(LedgGrp::class, 'up_gr', 'gr_code')
            ->where('Co_Id', $this->Co_Id)
            ->orderBy('gr_sr');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_del', '!=', 'Y');
    }

    public function scopeLevel($query, $level)
    {
        return $query->where('gr_stt', $level);
    }

    // Helpers
    public function isRootLevel(): bool
    {
        return $this->gr_stt === 1;
    }

    public function hasChildren(): bool
    {
        return $this->childGroups()->exists();
    }

    public function getLevelNameAttribute(): string
    {
        return match ($this->gr_stt) {
            1 => 'Root Level',
            2 => 'Level 2',
            3 => 'Level 3',
            4 => 'Level 4',
            default => 'Unknown Level',
        };
    }

    public function getSeriesAttribute(): string
    {
        return substr($this->gr_code, 0, 2);
    }
}
