<?php
// app/Models/PayCommissionMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayCommissionMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'commission_id';

    protected $fillable = [
        'commission_name',
        'structure_type_id',   // ✅ added

        'effective_from',
        'effective_to',
        'description',
        'is_active'
    ];

    protected $casts = [
        'effective_from' => 'date',
        'effective_to' => 'date',
        'is_active' => 'boolean'
    ];

    public function structureType()
    {
        return $this->belongsTo(
            PayStructureTypeMaster::class,
            'structure_type_id',
            'structure_type_id'
        );
    }

    public function payScales()
    {
        return $this->hasMany(PayScaleMaster::class, 'commission_id');
    }

    public function payBands()
    {
        return $this->hasMany(PayBandMaster::class, 'commission_id');
    }

    public function gradePays()
    {
        return $this->hasMany(GradePayMaster::class, 'commission_id');
    }

    public function payMatrixLevels()
    {
        return $this->hasMany(PayMatrixLevelMaster::class, 'commission_id');
    }
}
