<?php
// app/Models/PayMatrixCellMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayMatrixCellMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'cell_id';

    protected $fillable = [
        'level_id',
        'cell_index',
        'basic_pay'
    ];

    protected $casts = [
        'basic_pay' => 'decimal:2'
    ];

    public function level()
    {
        return $this->belongsTo(PayMatrixLevelMaster::class, 'level_id');
    }
}
