<?php
// app/Models/PayMatrixLevelMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayMatrixLevelMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'level_id';

    protected $fillable = [
        'commission_id',
        'pay_scale_id',        // ✅ added

        'level_code',
        'starting_basic'
    ];

    protected $casts = [
        'starting_basic' => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'commission_id');
    }
    // Pay Scale relation (nullable FK)
    public function payScale()
    {
        return $this->belongsTo(PayScaleMaster::class, 'pay_scale_id');
    }
    public function matrixCells()
    {
        return $this->hasMany(PayMatrixCellMaster::class, 'level_id');
    }
}
