<?php
// app/Models/PayScaleMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayScaleMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'pay_scale_id';

    protected $fillable = [
        'commission_id',
        'scale_code',
        'start_basic',
        'increment_amount',
        'increment_steps',
        'max_basic'
    ];

    protected $casts = [
        'start_basic' => 'decimal:2',
        'increment_amount' => 'decimal:2',
        'max_basic' => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'commission_id');
    }
}
