<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PermissionType extends Model
{
    protected $table = 'permission_types';

    protected $fillable = [
        'id',
        'name'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_role', 'permission_type_id', 'permission_id')
                    ->withPivot('role_id');
    }

    public function roles()
    {
        return $this->belongsToMany(RoleMaster::class, 'permission_role', 'permission_type_id', 'role_id')
                    ->withPivot('permission_id');
    }
}
