<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrtyMast extends Model
{
    use HasFactory;

    protected $table = 'prty_masts';
    protected $primaryKey = 'Pr_Id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = false;

    protected $fillable = [
        'Co_Id',
        'Br_Id',
        'pr_code',
        'pr_gr',
        'an_id',
        'pr_ct_id',
        'pr_td_id',
        'pr_fb_id',
        'pr_bk_id',
        'pr_name',
        'pr_ad_pr_no',
        'pr_ad_pr_nm',
        'pr_ad_nr_lm',
        'pr_ad_strt',
        'pr_ar_id',
        'pr_eml',
        'pr_web',
        'pr_ph',
        'pr_cp',
        'pr_ref',
        'pr_hld',
        'pr_rmk',
        'pr_cr_l',
        'pr_dp',
        'pr_cr_d',
        'pnl_int',
        'pr_bl_p',
        'pr_rpt',
        'cq_clr',
        'pr_st',
        'pr_cst',
        'pr_vat',
        'pr_pa',
        'pr_reg',
        'pr_ecx',
        'pr_ecc',
        'pr_e_ad',
        'pr_e_dv',
        'pr_e_col',
        'pr_e_rng',
        'pr_e_ra1',
        'pr_trn',
        'pr_sub',
        'tallydata',
        'sn_func_id',
        'sb_func',
        'pr_bl_t',
        'op_id',
        'dt_tm',
        'opb_amt',
        'cur_amt',
    ];

    protected $casts = [
        'pr_cr_l' => 'decimal:2',
        'pr_dp' => 'decimal:2',
        'pr_cr_d' => 'decimal:0',
        'pnl_int' => 'decimal:2',
        'cq_clr' => 'decimal:0',
        'sn_func_id' => 'decimal:0',
        'opb_amt' => 'decimal:2',
        'cur_amt' => 'decimal:2',
    ];

    // Relationships
    public function coMaster()
    {
        return $this->belongsTo(CoMaster::class, 'Co_Id', 'Co_Id');
    }

    public function branchM()
    {
        return $this->belongsTo(BranchM::class, 'Br_Id', 'Br_Id');
    }
}
