<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubSubCategory extends Model
{
    use HasFactory;

    protected $table = 'sub_sub_categories';
    protected $primaryKey = 'sub_sub_category_id';
    public $timestamps = true;

    protected $fillable = [
        'sub_category_id',
        'sub_sub_category_name',
        'sub_sub_category_code',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationship with SubCategory
    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'sub_category_id', 'sub_category_id');
    }

    // Relationship with Category through SubCategory
    public function category()
    {
        return $this->hasOneThrough(
            Category::class,
            SubCategory::class,
            'sub_category_id', // Foreign key on SubCategory table
            'category_id', // Foreign key on Category table
            'sub_category_id', // Local key on SubSubCategory table
            'category_id' // Local key on SubCategory table
        );
    }
}
