<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaxTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'tax_type_master';
    protected $primaryKey = 'tax_type_id';

    protected $fillable = [
        'tax_code',
        'tax_name',
        'tax_percentage',
        'frequency',
        'calculation_method',
        'is_active'
    ];

    
public function getTaxTypesFromParameters()
{
    if (!is_array($this->tax_parameters)) {
        return collect();
    }

    $taxTypeIds = collect($this->tax_parameters)->pluck('tax_type_id')->unique();

    if ($taxTypeIds->isEmpty()) {
        return collect();
    }

    return TaxTypeMaster::whereIn('tax_type_id', $taxTypeIds)->get();
}

public function getLedgersFromParameters()
{
    if (!is_array($this->tax_parameters)) {
        return collect();
    }

    $ledgerIds = collect($this->tax_parameters)->pluck('Lg_Id')->unique();

    if ($ledgerIds->isEmpty()) {
        return collect();
    }

    return LedgerMaster::whereIn('Lg_Id', $ledgerIds)->get();
}
}
