<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderEntryMaster extends Model
{
    use HasFactory;

    protected $table = 'tender_entry_master';
    protected $primaryKey = 'Tend_Ent_Id';
    public $incrementing = true;
    public $timestamps = true;

    protected $fillable = [
        'Bra_id',
        'Lg_Id',
        'tend_work_id',
        'Proposal_Amount',
        'available_amount',
        'Date',
        'Description',
        'Doc_Lib',
    ];

    protected $casts = [
        'Date' => 'date',
        'Proposal_Amount' => 'decimal:2',
        'available_amount' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationship with main_departments
    public function department()
    {
        return $this->belongsTo(MainDepartment::class, 'Bra_id', 'id');
    }

    // Relationship with ledger_master
    public function ledger()
    {
        return $this->belongsTo(LedgerMaster::class, 'Lg_Id', 'Lg_Id');
    }

    // Relationship with new_tender_works
    public function tenderWork()
    {
        return $this->belongsTo(NewTenderWork::class, 'tend_work_id', 'tend_work_id');
    }

    // Relationship with document_library (linked via Doc_Lib)
    public function documentLibrary()
    {
        return $this->belongsTo(DocumentLibrary::class, 'Doc_Lib', 'Doc_Lib');
    }

    // Relationship for all uploaded documents (using Rec_Id = Tend_Ent_Id)
    // FIXED: Removed Menu_Id condition or made it optional
    public function uploadedDocuments()
    {
        return $this->hasMany(DocumentLibrary::class, 'Rec_Id', 'Tend_Ent_Id');
                    // ->where('Menu_Id', $this->Bra_id); // Remove this or make it optional
    }

    // Relationship for all documents including the linked one
    public function allDocuments()
    {
        return $this->hasMany(DocumentLibrary::class, 'Rec_Id', 'Tend_Ent_Id')
                    ->orderBy('Serial_No', 'asc');
    }
}
