<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TendorAllocation extends Model
{
    use HasFactory;

    protected $table = 'tendor_allocation';
    protected $primaryKey = 'Tend_Alloc';
    public $incrementing = true;
    public $timestamps = true;

    protected $fillable = [
        'Tend_Ent_Id',
        'SL_Id',
        'Gross_Amount',
        'Multi_Doc'
    ];

    protected $casts = [
        'Gross_Amount' => 'decimal:2',
        'Multi_Doc' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationship with tender_entry_master
    public function tenderEntry()
    {
        return $this->belongsTo(TenderEntryMaster::class, 'Tend_Ent_Id', 'Tend_Ent_Id');
    }

    // Relationship with subledg_master - using SL_Id as foreign key
    public function subLedger()
{
    return $this->belongsTo(SubLedgerMaster::class, 'SL_Id', 'SL_Id');
}

    // Relationship with document_library
    public function documents()
    {
        return $this->hasMany(DocumentLibrary::class, 'Rec_Id', 'Tend_Alloc');
    }

    // Accessor for Multi_Doc
    public function getMultiDocAttribute($value)
    {
        if (is_string($value)) {
            return json_decode($value, true);
        }
        return $value;
    }

    // Mutator for Multi_Doc
    public function setMultiDocAttribute($value)
    {
        if (is_array($value)) {
            $this->attributes['Multi_Doc'] = json_encode($value);
        } else {
            $this->attributes['Multi_Doc'] = $value;
        }
    }
}
