<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkAllocation extends Model
{
    use HasFactory;

    protected $table = 'work_allocation';
    protected $primaryKey = 'wk_allow';

    protected $fillable = [
        'SL_Id',
        'Tend_Ent_Id',
        'work_amount',
        'work_date'
    ];

    public function subLedger()
    {
        return $this->belongsTo(SubLedgerMaster::class, 'SL_Id', 'SL_Id');
    }

    public function tenderEntry()
    {
        return $this->belongsTo(TenderEntryMaster::class, 'Tend_Ent_Id', 'Tend_Ent_Id');
    }
}
