<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('branch_ms', function (Blueprint $table) {
            $table->id('Br_Id'); // Auto-incrementing primary key
            $table->bigInteger('Co_Id')->unsigned(); // Foreign key
            $table->string('br_df', 1)->nullable();
            $table->string('br_nm', 35)->nullable();
            $table->string('br_ad_pr_no', 10)->nullable();
            $table->string('br_ad_pr_nm', 45)->nullable();
            $table->string('br_ad_nr_lm', 45)->nullable();
            $table->string('br_ad_strt', 45)->nullable();
            $table->string('br_ad_area', 20)->nullable();
            $table->string('br_ad_city', 20)->nullable();
            $table->string('br_ad_stat', 20)->nullable();
            $table->string('br_ad_pin_c', 7)->nullable();
            $table->string('br_ph', 35)->nullable();
            $table->string('br_s_rt', 20);
            $table->string('br_p_rt', 20)->nullable();
            $table->string('tallydata', 50)->nullable();
            $table->string('tallydata1', 50)->nullable();
            $table->string('t_port', 5)->nullable();
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->string('dept_id', 50)->nullable();
            $table->string('br_grp', 4)->nullable();
            $table->string('br_coll_name', 50)->nullable();

            $table->unique(['Co_Id', 'br_id']);
            $table->foreign('Co_Id')->references('Co_Id')->on('co_masters')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_ms');
    }
};
