<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sub_finan_trns', function (Blueprint $table) {
            $table->id('Sft_Id'); // Auto-incrementing primary key
            $table->bigInteger('Co_Id')->unsigned(); // Foreign key to co_masters
            $table->bigInteger('Br_Id')->unsigned(); // Foreign key to branch_ms
            $table->bigInteger('Ft_Id')->unsigned(); // Foreign key to finan_trns
            $table->string('vou_ty', 3);
            $table->integer('vou_id');
            $table->integer('vou_sr');
            $table->integer('vou_ln');
            $table->integer('sub_sr_no');
            $table->decimal('inst_no', 18, 0)->nullable();
            $table->decimal('agt_amt', 19, 4)->nullable();
            $table->string('chq_no', 12)->nullable();
            $table->dateTime('pymt_dt')->nullable();
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->string('ag_id', 50)->nullable();
            $table->decimal('in_no', 18, 0)->nullable();
            $table->integer('inq_id')->nullable();
            $table->decimal('chq_ret', 9, 2)->nullable();
            $table->decimal('loan_incom', 9, 2)->nullable();

            $table->foreign('Co_Id')->references('Co_Id')->on('co_masters')->onDelete('cascade');
            $table->foreign('Br_Id')->references('Br_Id')->on('branch_ms')->onDelete('cascade');
            $table->foreign('Ft_Id')->references('Ft_Id')->on('finan_trns')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sub_finan_trns');
    }
};
