<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gmc_users', function (Blueprint $table) {
            // Primary Key
            $table->id('user_id');

            // Authentication
            $table->string('username', 50)->unique();
            $table->string('password_hash', 255);
            $table->unsignedBigInteger('Role_Id')->nullable();

            // Contact Information
            $table->string('email', 100)->unique()->nullable();
            $table->string('mobile', 15)->unique()->nullable();

            // Account Status
            $table->boolean('is_active')->default(true);
            $table->boolean('is_locked')->default(false);
            $table->text('locked_reason')->nullable();
            $table->timestamp('locked_until')->nullable();
            $table->integer('failed_login_attempts')->default(0);

            // Security Tracking
            $table->timestamp('last_login')->nullable();
            $table->timestamp('last_password_change')->nullable();

            // MFA (Multi-Factor Authentication)
            $table->boolean('mfa_enabled')->default(false);
            $table->string('mfa_secret', 100)->nullable();

            // Session & Password Policies
            $table->integer('session_timeout')->default(30);
            $table->integer('password_expiry_days')->default(90);

            // Soft Delete
            $table->timestamp('deleted_at')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->text('deletion_reason')->nullable();

            // Audit Trail
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            // Foreign Keys
            $table->foreign('Role_Id')->references('Role_Id')->on('role_master')->onDelete('set null');
            $table->foreign('deleted_by')->references('user_id')->on('gmc_users')->onDelete('set null');
            $table->foreign('created_by')->references('user_id')->on('gmc_users')->onDelete('set null');
            $table->foreign('updated_by')->references('user_id')->on('gmc_users')->onDelete('set null');

            // Indexes
            $table->index('username');
            $table->index('email');
            $table->index('mobile');
            $table->index('is_active');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gmc_users');
    }
};
