<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_role_mapping', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('URoleMap');

            // Foreign Keys
            $table->unsignedBigInteger('U_Id');
            $table->unsignedBigInteger('Role_Id');
            $table->unsignedTinyInteger('Default_Rid')->default(0);

            // Timestamps
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('U_Id')
                  ->references('user_id')
                  ->on('gmc_users')
                  ->onDelete('cascade');

            $table->foreign('Role_Id')
                  ->references('Role_Id')
                  ->on('role_master')
                  ->onDelete('cascade');

            // Unique Constraint - One user can have multiple roles but not duplicate role
            $table->unique(['U_Id', 'Role_Id']);

            // Indexes for Performance
            $table->index('U_Id');
            $table->index('Role_Id');
            $table->index('Default_Rid');
            $table->index(['U_Id', 'Default_Rid']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_role_mapping');
    }
};
