<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('permissions', function (Blueprint $table) {
            $table->unsignedInteger('id')->primary();
            $table->string('name', 191);
            $table->string('display_name', 191)->nullable();
            $table->string('description', 191)->nullable();
            $table->unsignedInteger('module_id');
            $table->boolean('is_custom')->default(false);
            $table->text('allowed_permissions')->nullable();
            $table->timestamps();

            $table->foreign('module_id')->references('id')->on('modules')->onDelete('cascade');
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('permissions');
    }
};
