<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('fas_funds_type_master', function (Blueprint $table) {
            $table->id('funds_type_id');
            $table->string('funds_code', 20)->unique();
            $table->string('funds_name', 100);
            $table->string('category', 20)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('fas_funds_type_master');
    }
};
