<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('scheme_type_master', function (Blueprint $table) {
            $table->id('scheme_type_id');
            $table->string('scheme_type_code', 20)->unique();
            $table->string('scheme_type_name', 150);
            $table->string('funding_source', 100)->nullable();
            $table->string('description', 255)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('scheme_type_master');
    }
};
