<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('function_types', function (Blueprint $table) {
            // Add func_id as nullable foreign key
            $table->unsignedBigInteger('func_id')->nullable()->after('category_id');

            // Add foreign key constraint
            $table->foreign('func_id')
                  ->references('id')
                  ->on('function_types')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('function_types', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['func_id']);

            // Then drop the column
            $table->dropColumn('func_id');
        });
    }
};
