<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('ward_master', function (Blueprint $table) {
            $table->id('Ward_Id');
            $table->string('Ward_Code', 5);
            $table->string('Ward_Name', 25);
            $table->foreignId('Zone_Id')->constrained('zone_masters', 'Zone_Id');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            // Unique constraint for ward code per zone
            $table->unique(['Ward_Code', 'Zone_Id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('ward_master');
    }
};
