<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ward_statistics', function (Blueprint $table) {
            $table->id('WD_St_Id');
            $table->foreignId('Ward_Id')
                  ->constrained('ward_master', 'Ward_Id')
                  ->onDelete('cascade');
            $table->string('St_Date', 25);
            $table->string('Population', 1)->nullable();
            $table->decimal('Area_SqKm', 10, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            // Add unique constraint for ward_id and st_date combination
            $table->unique(['Ward_Id', 'St_Date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ward_statistics');
    }
};
