<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ccc_master', function (Blueprint $table) {
            $table->id('CCC_Id');
            $table->string('CCC_Code', 5);
            $table->string('CCC_Name', 25);
            $table->foreignId('Ward_Id')
                  ->constrained('ward_master', 'Ward_Id')
                  ->onDelete('restrict');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            // Add unique constraint for CCC_Code
            $table->unique('CCC_Code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ccc_master');
    }
};
