<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_master', function (Blueprint $table) {
            $table->id('Role_Id');
            $table->string('Role_Prefix', 5)->nullable();
            $table->string('Role_Name', 25);
            $table->string('TwoFacAuth', 1)->nullable()->comment('Y=Yes, N=No');
            $table->boolean('Is_Active')->default(true);
            $table->timestamps();

            // Add unique constraint for Role_Name
            $table->unique('Role_Name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_master');
    }
};
