<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('area_master', function (Blueprint $table) {
            $table->bigIncrements('Area_Id');
            $table->string('Area_Code', 5)->unique();
            $table->string('Area_Name', 25);
            $table->bigInteger('Ward_ID')->nullable();
            $table->timestamp('Created_Date')->useCurrent();

            $table->index('Ward_ID');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('area_master');
    }
};
